%% Generate time series
% Generate multivariate time series, each of them a linear combination of
% sinusoids with different period length |f0| and variance |f0Var|.
% Furthermore, red noise realized as an AR(1) process with a noise level
% |NoiseLevel| is added. The AR(1) parametes are randomly chosen in
% |ARCoeff|.

clear all;
t=(1:130)';
f0 = 1./[7.5  6.0 2.8  2.3];


f0Var = [
         0.4  0.0 0.3  0.3 ;...         
         0.4  0.2 0.4  0.0 ;...
         0.3  0.3 0.0  0.4 ;...
         0.0  0.4 0.4  0.2 ;...
         0.2  0.4 0.0  0.4 ;...
         0.3  0.0 0.4  0.3];



D=size(f0Var,1);

rng('default');
N=length(t);



NoiseLevel=0.7; %% 

ARCoeff=rand(1,D)*0.1+0.55;
ARVar=1-ARCoeff.^2;

% combination of sinusoids
xreff=zeros(N,D,length(f0));
xref=zeros(N,D);
for d=1:D
  for pos=1:length(f0);
    xreff(:,d,pos)=sqrt(f0Var(d,pos))*sin(2*pi*f0(pos)*t+rand(1)*2*pi);
  end
end
xref=squeeze(sum(xreff,3));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xref1=squeeze(xreff(:,:,1))/sqrt(0.5)*sqrt(1-NoiseLevel);
xref2=squeeze(xreff(:,:,2))/sqrt(0.5)*sqrt(1-NoiseLevel);
xref3=squeeze(xreff(:,:,3))/sqrt(0.5)*sqrt(1-NoiseLevel);
xref4=squeeze(xreff(:,:,4))/sqrt(0.5)*sqrt(1-NoiseLevel);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xref=xref/sqrt(0.5);
%%%%%%%%%%%%%%%%%%%%%%%%%%%



% AR(1) process
r=randn(N,D);
for d=1:D
  r(:,d)=filter(sqrt(ARVar(d)),[1 -ARCoeff(d)],r(:,d));
end

% sinusoid + AR(1)
data=sqrt(1-NoiseLevel)*xref + sqrt(NoiseLevel)*r;
noise = sqrt(NoiseLevel)*r;
xref = sqrt(1-NoiseLevel)*xref;
signal = xref;


